const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function visitas_planificadas() {

    let ciclo = $('#lista_ciclos').val();
    let lista_tipo_cliente = $('#lista_tipo_cliente').val();

    $.get(`back-end/inicio/inicio.php?visitas_planificadas=${'all'}&ciclo=${ciclo}&lista_clientes=${lista_tipo_cliente}`, function (respose) {

        let o = JSON.parse(respose);

        let body = `<h5 class="font-weight-bolder mb-0">${o[0].visitas_planificadas}</h5>`
        $('#visitas_planificadas').html(body);
    });
}

function visitas_gestionadas() {

    let ciclo = $('#lista_ciclos').val();
    let lista_tipo_cliente = $('#lista_tipo_cliente').val();

    $.get(`back-end/inicio/inicio.php?visitas_gestionadas=${'all'}&ciclo=${ciclo}&lista_clientes=${lista_tipo_cliente}`, function (respose) {

        let o = JSON.parse(respose);

        let body = `<h5 class="font-weight-bolder mb-0">${o[0].visitas_gestionadas}</h5>`;
        $('#visitas_gestionadas').html(body);

    });
}

function visitas_pendientes() {

    let ciclo = $('#lista_ciclos').val();
    let lista_tipo_cliente = $('#lista_tipo_cliente').val();

    $.get(`back-end/inicio/inicio.php?visitas_pendientes=${'all'}&ciclo=${ciclo}&lista_clientes=${lista_tipo_cliente}`, function (respose) {
        let o = JSON.parse(respose);

        let body = `<h5 class="font-weight-bolder mb-0">${o[0].visitas_pendientes}</h5>`;
        $('#visitas_pendientes').html(body);
    });
}

function visitas_anuladas() {
    let ciclo = $('#lista_ciclos').val();
    let lista_tipo_cliente = $('#lista_tipo_cliente').val();

    $.get(`back-end/inicio/inicio.php?visitas_anuladas=${'all'}&ciclo=${ciclo}&lista_clientes=${lista_tipo_cliente}`, function (respose) {
        let o = JSON.parse(respose);

        let body = `<h5 class="font-weight-bolder mb-0">${o[0].visitas_anuladas}</h5>`;
        $('#visitas_anuladas').html(body);
    });
}

function sumatoria_objetivos() {
    let ciclo = $('#lista_ciclos').val();
    let lista_tipo_cliente = $('#lista_tipo_cliente').val();

    $.get(`back-end/inicio/inicio.php?sumatoria_objetivos=${'all'}&ciclo=${ciclo}&lista_clientes=${lista_tipo_cliente}`, function (respose) {
        let o = JSON.parse(respose);

        let body = `<h5 class="font-weight-bolder mb-0">${o[0].sumatoria_objetivos}</h5>`;
        $('#sumatoria_objetivos').html(body);
    });
}

function porcentaje_cumplimiento() {

    let ciclo = $('#lista_ciclos').val();
    let lista_tipo_cliente = $('#lista_tipo_cliente').val();

    $.get(`back-end/inicio/inicio.php?porcentaje_cumplimiento=${'all'}&ciclo=${ciclo}&lista_clientes=${lista_tipo_cliente}`, function (respose) {
        console.log(respose);
        let dato = parseInt((respose * 100));

        if (isNaN(dato)) {
            dato = 0;
        }

        let body = `<h5 class="font-weight-bolder mb-0">${dato + "%"}</h5>`;
        $('#porcentaje_cumplimiento').html(body);
    });
}

async function aplicar_filtro() {

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });
    await visitas_planificadas();

    await visitas_planificadas();
    await visitas_gestionadas();
    await visitas_pendientes();
    await visitas_anuladas();
    await sumatoria_objetivos();
    await porcentaje_cumplimiento();
    await estadisticas_visitadores();
    await carteles_filtro();

    Toast.fire({
        icon: 'success',
        title: 'Filtro Aplicado'
    });

    await Swal.close();
}

function lista_cumple() {
    $.get(`back-end/inicio/inicio.php?lista_cumple=${'all'}`, function (respose) {

        let o = JSON.parse(respose);
        let body = ``;

        o.forEach(data => {
            body += `
                <tr>
                    <td style="font-size: 12px;" class="text-center font-weight-normal">${data.nombre_cliente}</td>
                    <td style="font-size: 12px;" class="text-center font-weight-normal">${data.fecha_cumple}</td>
                </tr>`;
        });

        $('#lista_cumple').html(body);
    });
}

function lista_compromisos() {
    $.get(`back-end/inicio/inicio.php?lista_compromisos=${'all'}`, function (respose) {

        let o = JSON.parse(respose);
        let body = ``;

        o.forEach(data => {
            body += `
                <tr>
                    <td style="font-size: 12px;" class="text-center font-weight-normal">${data.nombre_cliente}</td>
                    <td style="font-size: 12px;" class="text-center font-weight-normal">${data.fecha_compromiso}</td>
                    <td style="font-size: 12px;" class="text-center font-weight-normal">${data.compromiso}</td>
                </tr>`;
        });

        $('#lista_compromisos').html(body);
    });
}

function estadisticas_visitadores() {

    let ciclo = $('#list_ciclo').val();

    $.get(`back-end/inicio/inicio.php?esta_visit=${'all'}&ciclo=${ciclo}`, function (response) {

        let o = JSON.parse(response);
        // console.log(o);

        let body = ``;

        o.forEach(data => {

            let cumplimiento = data.total_cumpli;

            if (isNaN(cumplimiento)) {
                cumplimiento = 0;
            }

            body += `
                <tr>
                    <td rowspan="2" class="w-30">
                        <div class="d-flex px-2 py-1 align-items-center">
                            <div class="ms-4">
                                <p class="text-xs font-weight-bold mb-0">Visitador:</p>
                                <h6 class="text-sm mb-0">${data.name_user}</h6>
                            </div>
                        </div>
                    </td>
                    <td>
                        <div class="text-center">
                            <p class="text-xs font-weight-bold mb-0">Objetivos Medico:</p>
                            <h6 class="text-sm mb-0">${data.cantidad_medico}</h6>
                        </div>
                    </td>
                    <td>
                        <div class="text-center">
                            <p class="text-xs font-weight-bold mb-0">Gestionadas:</p>
                            <h6 class="text-sm mb-0">${data.gestionada_medico}</h6>
                        </div>
                    </td>
                    <td class="align-middle text-sm">
                        <div class="col text-center">
                            <p class="text-xs font-weight-bold mb-0">Cumplimiento:</p>
                            <h6 class="text-sm mb-0">${((data.gestionada_medico * 100) / data.cantidad_medico).toFixed(2)}%</h6>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>
                        <div class="text-center">
                            <p class="text-xs font-weight-bold mb-0">Objetivos Farmacia:</p>
                            <h6 class="text-sm mb-0">${data.cantidad_farmacia}</h6>
                        </div>
                    </td>
                    <td>
                        <div class="text-center">
                            <p class="text-xs font-weight-bold mb-0">Gestionadas:</p>
                            <h6 class="text-sm mb-0">${data.gestionada_farmacia}</h6>
                        </div>
                    </td>
                    <td class="align-middle text-sm">
                        <div class="col text-center">
                            <p class="text-xs font-weight-bold mb-0">Cumplimiento:</p>
                            <h6 class="text-sm mb-0">${((data.gestionada_farmacia * 100) / data.cantidad_farmacia).toFixed(2)}%</h6>
                        </div>
                    </td>
                </tr>
            `;
        });
        $('#estadisticas_visitadores').html(body);
    });
}

async function lista_ciclos() {

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    await $.get(`back-end/inicio/inicio.php?lista_ciclos=${'all'}`, async function (response) {

        let o = JSON.parse(response);

        let templete = `<select class="form-control" id="lista_ciclos">`;
        let body = ``;
        let templete_end = `</select>`;

        o.forEach(data => {
            body += `
                <option value='${data.id}'>${data.ciclo}</option>
            `;
        });

        await $('#container_lista_ciclos').html(templete + body + templete_end);
    });

    await lista_tipo_cliente();
    await visitas_planificadas();
    await visitas_pendientes();
    await visitas_gestionadas();
    await visitas_anuladas();
    await sumatoria_objetivos();
    await porcentaje_cumplimiento();
    await estadisticas_visitadores();
    await carteles_filtro();

    await Swal.close();
}

async function lista_tipo_cliente() {

    Swal.fire({
        title: 'Cargando...',
        html: 'Espere un momento por favor.',
        allowOutsideClick: false,
        didOpen: () => {
            Swal.showLoading();
        }
    });

    await $.get(`back-end/inicio/inicio.php?lista_tipo_cliente=${'all'}`, async function (response) {

        let o = JSON.parse(response);

        let templete = `<select class="form-control" id="lista_tipo_cliente">`;
        let body = `
            <option value=''>Seleccione</option>
            <option value='Todos'>Todos</option>
            `;
        let templete_end = `</select>`;

        o.forEach(data => {
            body += `
                <option value='${data.id_tipo_c}'>${data.tipo_c}</option>
            `;
        });

        await $('#container_lista_tipo_cliente').html(templete + body + templete_end);
    });

    await Swal.close();
}

function carteles_filtro() {

    let ciclo = $('#lista_ciclos').val();
    let lista_clientes = $('#lista_tipo_cliente').val();

    $.get(`back-end/inicio/inicio.php?carteles_filtro=${'all'}&lista_clientes=${lista_clientes}&ciclo=${ciclo}`, function (response) {

        let o = JSON.parse(response);
        console.log(o)

        $('#ciclo_actual').html(o.ciclo + ' - ' + o.tipo_cliente);
    });
}














function consulta_lineas() {
    let reporte_cab = 'ALL';
    let fi = $("#fecha_ini").val();
    let ff = $("#fecha_fin").val();
    let ciclo = $('#list_ciclo').val();

    $.ajax({
        url: 'back-end/reportes.php',
        type: 'GET',
        data: { reporte_cab, fi, ff, ciclo },
        success: function (response) {
            let datas = JSON.parse(response);
            console.log(datas);
            let template = '';
            datas.forEach(data => {
                template += `
                <tr>
                    <td class="text-center text-sm font-weight-normal">${data.tipo}</td>
                    <td class="text-center text-sm font-weight-normal">${data.total}</td>
                    <td class="text-center text-sm font-weight-normal">${data.gestionadas}</td>
                    <td class="text-center text-sm font-weight-normal">${data.pendientes}</td>
                    <td class="text-center text-sm font-weight-normal">${data.cumplimiento}</td>
                    <td class="text-center text-sm font-weight-normal">${data.objetivo}</td>
                    <td class="text-center text-sm font-weight-normal">${data.cumple_obj}</td>
                </tr>`
            });
            $('#lineas_tipo').html(template);
        }
    });

    $.ajax({
        url: 'back-end/inicio/inicio.php',
        type: 'GET',
        data: { reporte_cab, fi, ff, ciclo },
        success: function (response) {
            let datas = JSON.parse(response);
            console.log(datas);

            let visitas_planificadas = 0;
            let visitas_pendientes = 0;
            let visitas_gestionadas = 0;
            let sumatoria_objetivos = 0;
            let visitas_anuladas = 0;
            let dato = 0;

            datas.forEach(item => {
                dato_object = item.objetivo.replace(',', '')
                visitas_planificadas += parseInt(item.total);
                visitas_pendientes += parseInt(item.pendientes);
                visitas_gestionadas += parseInt(item.gestionadas);
                visitas_anuladas += parseInt(item.anuladas);
                sumatoria_objetivos += parseInt(dato_object);
            });

            console.log(sumatoria_objetivos)

            dato = (visitas_gestionadas / visitas_planificadas) * 100;
            dato2 = (visitas_gestionadas / sumatoria_objetivos) * 100;

            let body_plan = `<h5 class="font-weight-bolder mb-0">${visitas_planificadas}</h5>`
            $('#visitas_planificadas').html(body_plan);

            let body_pend = `<h5 class="font-weight-bolder mb-0">${visitas_pendientes}</h5>`;
            $('#visitas_pendientes').html(body_pend);

            let body_anuladas = `<h5 class="font-weight-bolder mb-0">${visitas_anuladas}</h5>`;
            $('#visitas_anuladas').html(body_anuladas);

            let body_objet = `<h5 class="font-weight-bolder mb-0">${sumatoria_objetivos}</h5>`;
            $('#sumatoria_objetivos').html(body_objet);

            let body_gesti = `<h5 class="font-weight-bolder mb-0">${visitas_gestionadas}</h5>`;
            $('#visitas_gestionadas').html(body_gesti);

            let body_cumpli = `<h5 class="font-weight-bolder mb-0">${Math.trunc(dato) + "%"}</h5>`;
            $('#porcentaje_cumplimiento_pg').html(body_cumpli);

            let body_cumpli2 = `<h5 class="font-weight-bolder mb-0">${Math.trunc(dato2) + "%"}</h5>`;
            $('#porcentaje_cumplimiento_go').html(body_cumpli2);
        }
    });
    estadisticas_visitadores()
}

function consulta_lineas_v() {
    let reporte_lin = 'ALL';
    let fi = $("#fecha_ini").val();
    let ff = $("#fecha_fin").val();
    let ciclo = $('#list_ciclo').val();
    $.ajax({
        url: 'back-end/reportes.php',
        type: 'GET',
        data: { reporte_lin, fi, ff, ciclo },
        success: function (response) {
            let datas = JSON.parse(response);
            console.log(datas);
            let template = '';
            datas.forEach(data => {
                template += `
                <tr>
                    <td class="text-center text-sm font-weight-normal">${data.visitador}</td>
                    <td class="text-center text-sm font-weight-normal">${data.tipo}</td>
                    <td class="text-center text-sm font-weight-normal">${data.total}</td>
                    <td class="text-center text-sm font-weight-normal">${data.gestionadas}</td>
                    <td class="text-center text-sm font-weight-normal">${data.pendientes}</td>
                    <td class="text-center text-sm font-weight-normal">${data.cumplimiento}</td>
                    <td class="text-center text-sm font-weight-normal">${data.objetivo}</td>
                    <td class="text-center text-sm font-weight-normal">${data.cumple_obj}</td>
                </tr>`

            });
            $('#lineas_visitador').html(template);
        }
    })
}

function list_ciclo() {

    let list_ciclo = 'ALL';

    $.ajax({
        url: 'back-end/objetivos_visita/objetivos_visita.php',
        type: 'GET',
        data: { list_ciclo },
        success: function (response) {

            let datas = JSON.parse(response);
            let list_ciclo_select = document.getElementById('list_ciclo');

            let opt = document.createElement('option');
            opt.value = "";
            opt.innerHTML = "Seleccione";
            list_ciclo_select.appendChild(opt);

            datas.forEach(data => {
                let opt = document.createElement('option');
                opt.value = data.id;
                opt.innerHTML = data.ciclo;
                list_ciclo_select.appendChild(opt);
            });

        }
    });

    var inputElement = document.getElementById("fecha_ini");
    var inputElement1 = document.getElementById("fecha_fin");
    var fecha = new Date(); //Fecha actual
    var mes = fecha.getMonth() + 1; //obteniendo mes
    var dia = fecha.getDate(); //obteniendo dia
    var ano = fecha.getFullYear(); //obteniendo a単o
    if (dia < 10)
        dia = '0' + dia; //agrega cero si el menor de 10
    if (mes < 10)
        mes = '0' + mes //agrega cero si el menor de 10 f_exp_mat
    //console.log(ano+"-"+mes+"-"+dia)

    inputElement.value = (ano + "-" + mes + "-" + dia);
    inputElement1.value = (ano + "-" + mes + "-" + dia);
}

function actualiza_fecha() {
    document.getElementById("f1").style.display = "block";
    document.getElementById("f2").style.display = "block";
    let id = $('#list_ciclo').val();
    $.get(`back-end/ciclos_visita/ciclos_visita.php?id_ciclo=${id}`, function (response) {
        let o = JSON.parse(response);
        //console.log(o[0]);
        $('#fecha_ini').val(o[0].fecha_desde);
        $('#fecha_fin').val(o[0].fecha_hasta);
        $('#fecha_ini_v').val(o[0].fecha_desde);
        $('#fecha_fin_v').val(o[0].fecha_hasta);
    });
}

function val_fecha_ini() {
    $f1 = $('#fecha_ini').val();
    $f2 = $('#fecha_ini_v').val();
    if ($f1 < $f2) {
        $('#fecha_ini').val($f2);
    }
}

function val_fecha_fin() {
    $f1 = $('#fecha_fin').val();
    $f2 = $('#fecha_fin_v').val();
    if ($f1 > $f2) {
        $('#fecha_fin').val($f2);
    }
}