const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

function linea_marca() {
    $.get(`back-end/marcas/marcas.php?lista_lineas='all'`, function (response) {

        let o = JSON.parse(response);

        let body = ``;

        o.forEach(element => {
            body += `<option value="${element.id_linea}">${element.linea}</option>`;
        });

        $('#linea_marca_crear').html(body);
        $('#linea_marca_editar').html(body);
    });
}

async function consul_marcas() {

    let templete = `
        <table class="table table-flush" id="datatable_marcas">
            <thead class="thead-light">
                <tr>
                    <th class="text-uppercase text-secondary text-lg font-weight-bolder opacity-7">Codigo Marca</th>
                    <th class="text-uppercase text-secondary text-lg font-weight-bolder opacity-7">Nombre Marca</th>
                    <th class="text-uppercase text-secondary text-lg font-weight-bolder opacity-7">Estado Marca</th>
                    <th class="text-uppercase text-secondary text-lg font-weight-bolder opacity-7">Linea Marca</th>
                    <th class="text-uppercase text-secondary text-lg font-weight-bolder opacity-7">Acciones</th>
                </tr>
            </thead>
            <tbody>`;
    let body = ``;
    let template_end = `</tbody></table>`;

    await $.get(`back-end/marcas/marcas.php?marcas=all`, function (response) {

        let o = JSON.parse(response);

        o.forEach(element => {
            body += `
                <tr>
                    <td class="text-md font-weight-normal">${element.codigo_marca}</td>
                    <td class="text-md font-weight-normal">${element.nombre_marca}</td>
                    <td class="text-md font-weight-normal">${element.estado_marca}</td>
                    <td class="text-md font-weight-normal">${element.linea_marca}</td>
                    <td class="text-md font-weight-normal">${element.btn_edit}</td>
                </tr>`;
        });

        $('#tabla_marcas').html(templete + body + template_end);
    });

    await new simpleDatatables.DataTable("#datatable_marcas", {
        searchable: true,
        fixedHeight: true
    });
}

function setid_marca(id) {
    $.get(`back-end/marcas/marcas.php?datos_marca='all'&id_marca=${id}`, function (response) {

        let o = JSON.parse(response);

        o.forEach(element => {
            $('#id_marca').val(element.id_marca);
            $('#nombre_marca').val(element.nombre_marca);
            $('#estado_marca').val(element.estado_marca);
            $('#linea_marca_editar').val(element.linea_marca);
        });
    });
}

function editar_marcar() {

    let id_marca = $('#id_marca').val();
    let nombre_marca = $('#nombre_marca').val();
    let estado_marca = $('#estado_marca').val();
    let linea_marca = $('#linea_marca_editar').val();

    const POSTDATA = {
        id_marca: id_marca,
        linea_marca: linea_marca,
        nombre_marca: nombre_marca,
        estado_marca: estado_marca,
    }

    $.post(`back-end/marcas/marcas.php`, POSTDATA, function (response) {

        let o = parseInt(response);

        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Actualizacion de Marca Exitosa'
            });
            consul_marcas();
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Actualizar Marca'
            });
        }

    });
}

function crear_marca() {

    let linea_marca = $('#linea_marca_crear').val();
    let crear_nombre = $('#crear_nombre').val();

    const POSTDATA = {
        crear_marca: 'all',
        linea_marca: linea_marca,
        crear_nombre: crear_nombre
    }

    $.post(`back-end/marcas/marcas.php`, POSTDATA, function (response) {
        console.log(response)
        let o = parseInt(response);

        if (o == 200) {
            Toast.fire({
                icon: 'success',
                title: 'Actualizacion de Marca Exitosa'
            });
            consul_marcas();
        } else {
            Toast.fire({
                icon: 'error',
                title: 'Error al Actualizar Marca'
            });
        }
    });
}


// exportar marcas
// function exportar_marcas() {
//     const tabla = document.querySelector("#datatable_marcas");
//     if (!tabla) {
//         Toast.fire({
//             icon: 'error',
//             title: 'No hay datos para exportar'
//         });
//         return;
//     }

//     // Crear un libro Excel a partir de la tabla
//     const wb = XLSX.utils.table_to_book(tabla, { sheet: "Marcas" });
//     const nombreArchivo = "marcas_" + new Date().toISOString().slice(0, 10) + ".xlsx";

//     // Descargar el archivo
//     XLSX.writeFile(wb, nombreArchivo);

//     Toast.fire({
//         icon: 'success',
//         title: 'Archivo exportado correctamente'
//     });
// }
async function exportar_marcas() {
    // 🔹 Mostrar mensaje inicial antes de hacer la solicitud
    Toast.fire({
        icon: 'info',
        title: 'Generando archivo, por favor espera...'
    });

    try {
        const response = await $.get(`back-end/marcas/marcas.php?marcas=all`);
        const marcas = JSON.parse(response);

        if (!marcas || marcas.length === 0) {
            Toast.fire({
                icon: 'error',
                title: 'No hay datos para exportar'
            });
            return;
        }

        // 🔹 Encabezados del archivo
        const headers = ["Código Marca", "Nombre Marca", "Estado Marca", "Línea Marca"];

        // 🔹 Limpiar etiquetas HTML del estado y crear los datos
        const data = marcas.map(m => {
            const estadoLimpio = m.estado_marca
                ? m.estado_marca.replace(/<[^>]*>?/gm, '').trim()
                : ''; // Evita error si es null o undefined

            return [
                m.codigo_marca,
                m.nombre_marca,
                estadoLimpio,
                m.linea_marca
            ];
        });

        // 🔹 Crear hoja y libro Excel
        const ws = XLSX.utils.aoa_to_sheet([headers, ...data]);
        const wb = XLSX.utils.book_new();
        XLSX.utils.book_append_sheet(wb, ws, "Marcas");

        // 🔹 Guardar archivo Excel
        const nombreArchivo = "marcas_" + new Date().toISOString().slice(0, 10) + ".xlsx";
        XLSX.writeFile(wb, nombreArchivo);

        Toast.fire({
            icon: 'success',
            title: 'Archivo exportado correctamente'
        });
    } catch (error) {
        console.error(error);
        Toast.fire({
            icon: 'error',
            title: 'Error al generar el archivo'
        });
    }
}
