const Toast = Swal.mixin({
    toast: true,
    position: 'top-end',
    showConfirmButton: false,
    timer: 3000,
    timerProgressBar: true,
    didOpen: (toast) => {
        toast.addEventListener('mouseenter', Swal.stopTimer)
        toast.addEventListener('mouseleave', Swal.resumeTimer)
    }
})

async function consul_objetivos() {
    let list_objetivos = 'ALL';

    await $.ajax({
        url: 'back-end/objetivos_visita/objetivos_visita.php',
        type: 'GET',
        data: { list_objetivos },
        success: function (response) {
            let datas = JSON.parse(response);
            let template = `                
            <table class="table table-flush" style="font-size: 10px;" id="datatable_lineas">
            <thead class="thead-light">
              <tr>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Id </th>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Visitador </th>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Ciclo </th>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Tipo </th>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Cantidad </th>
                <th class="text-center text-uppercase text-secondary font-weight-bolder opacity-7"> Editar </th>
              </tr>
            </thead>
        <tbody>`;
            let body = ``;
            let template_end = `</tbody></table>`;

            datas.forEach(data => {
                body += `
                <tr>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.id}</td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.visitador}</td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.ciclo}</td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.tipo_cliente}</td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.cantidad}</td>
                <td style="font-size: 10px;" class="text-center font-weight-normal">${data.btn_edit}</td>
            </tr>
                `
            });
            $('#tabla_objetivos').html(template + body + template_end);
        }
    });

    const dataTableSearch = new simpleDatatables.DataTable("#datatable_lineas", {
        searchable: true,
        fixedHeight: true
    });
}

function lista_clientes() {

    $.get(`back-end/objetivos_visita/objetivos_visita.php?lista_clientes=all`, function (response) {
        let o = JSON.parse(response);
        console.log(response);

        let body = ``;

        o.forEach(data => {
            body+=`
                <option value="${data.id_tipo_c}">${data.tipo_c}</option>
            `;
        });
        
        $('#tipo_cliente').html(body);
        $('#tipo_cliente_edit').html(body);
    });

}

function crearObjetivos() {
    let visitador = $('#visitador').val();
    let list_ciclo = $('#list_ciclo').val();
    let tipo_cliente = $('#tipo_cliente').val();
    let cantidad = $('#cantidad').val();

    $.post(`back-end/objetivos_visita/objetivos_visita.php`, { visitador, list_ciclo, tipo_cliente, cantidad }, function (response) {

        console.log(response)

        let o = parseInt(response);

        if (o == 200) {

            consul_objetivos();
            $('#nuevo_objetivos').modal("hide");

            Swal.fire({
                icon: 'success',
                title: 'Crear Objetivo',
                text: 'Creacion de objetivo exitosa.',
            })

            $('#visitador').val('');
            $('#list_ciclo').val('');
            $('#tipo_cliente').val('');
            $('#cantidad').val('');
        } else {
            Swal.fire({
                icon: 'error',
                title: 'Oops...',
                text: 'Error al crear el objetivo.',
            })
        }
    });
}

function editarObjetivo() {

    let id_objetivo_edit = $('#id_objetivo_edit').val();
    let visitador = $('#visitador_edit').val();
    let list_ciclo = $('#list_ciclo_edit').val();
    let tipo_cliente = $('#tipo_cliente_edit').val();
    let cantidad = $('#cantidad_edit').val();
    let comentarios_edit = $('#comentarios_edit').val();

    fetch(`back-end/objetivos_visita/objetivos_visita.php`, {
        method: 'PUT',
        body: JSON.stringify({
            id_objetivo_edit: id_objetivo_edit,
            visitador: visitador,
            list_ciclo: list_ciclo,
            tipo_cliente: tipo_cliente,
            cantidad: cantidad,
            comentarios_edit: comentarios_edit
        }),
        Headers: {
            Accept: 'application/json',
            'Content-Type': 'text/html'
        }
    })
        .then((response) => response.text())
        .then((responseData) => {
            console.log(responseData);
            let resp = parseInt(responseData);

            if (resp == 200) {
                consul_objetivos();
                $('#edit_objetivo').modal("hide");
                Toast.fire({
                    icon: 'success',
                    title: 'Objetivo Actualizado'
                });
            } else {
                Toast.fire({
                    icon: 'error',
                    title: 'Error al Actualizar el Objetivo'
                });
            }

        })
        .catch((error) => {
            console.error('error', error)
        });
}

function list_ciclo() {

    let list_ciclo = 'ALL';

    $.ajax({
        url: 'back-end/objetivos_visita/objetivos_visita.php',
        type: 'GET',
        data: { list_ciclo },
        success: function (response) {

            let datas = JSON.parse(response);
            let list_ciclo_select = document.getElementById('list_ciclo');

            let opt = document.createElement('option');
            opt.value = "";
            opt.innerHTML = "Seleccione";
            list_ciclo_select.appendChild(opt);

            datas.forEach(data => {
                let opt = document.createElement('option');
                opt.value = data.id;
                opt.innerHTML = data.ciclo;
                list_ciclo_select.appendChild(opt);
            });

        }
    });
}

function list_ciclo_edit(dato) {

    let list_ciclo = 'ALL';

    $.ajax({
        url: 'back-end/objetivos_visita/objetivos_visita.php',
        type: 'GET',
        data: { list_ciclo },
        success: function (response) {

            let datas = JSON.parse(response);
            let list_ciclo_select = document.getElementById('list_ciclo_edit');

            let opt = document.createElement('option');
            opt.value = "";
            opt.innerHTML = "Seleccione";
            list_ciclo_select.appendChild(opt);

            datas.forEach(data => {

                let opt = document.createElement('option');
                opt.value = data.id;
                opt.innerHTML = data.ciclo;

                if (data.id == dato) {
                    opt.selected = true;
                }

                list_ciclo_select.appendChild(opt);
            });
        }
    });
}

function list_visitadores() {

    let list_visitadores = 'ALL';

    $.ajax({
        url: 'back-end/objetivos_visita/objetivos_visita.php',
        type: 'GET',
        data: { list_visitadores },
        success: function (response) {

            let datas = JSON.parse(response);

            console.log(datas)

            let template = `<datalist id="visitadores_lista">`;
            let body = ``;
            let template_end = `</datalist>`;

            datas.forEach(data => {
                body += `
                    <option value="${data.id_user}">${data.name_user + " - " + data.id_user}</option>
                `;
            });

            $('#visitadores').html(template + body + template_end);
        }
    });
}

function list_visitadores_edit(dato) {

    let list_visitadores = 'ALL';

    $.ajax({
        url: 'back-end/objetivos_visita/objetivos_visita.php',
        type: 'GET',
        data: { list_visitadores },
        success: function (response) {

            let datas = JSON.parse(response);

            let template = `<datalist id="visitadores_lista_edit">`;
            let body = ``;
            let template_end = `</datalist>`;

            datas.forEach(data => {


                body += `
                        <option value="${data.id_user}">${data.name_user + " - " + data.id_user}</option>
                    `;


            });

            $('#visitadores_edit').html(template + body + template_end);
        }
    });

    $('#visitador_edit').val(dato);
}

async function setID(id) {
    await $('#id_objetivo_edit').val(id);

    await $.get(`back-end/objetivos_visita/objetivos_visita.php?id_objetivo=${id}`, async function (response) {

        let o = JSON.parse(response);

        await list_ciclo_edit(o[0].ciclo);
        await list_visitadores_edit(o[0].visitador);
        await $('#tipo_cliente_edit').val(o[0].tipo_cliente);
        await $('#cantidad_edit').val(o[0].cantidad);
        
        await $('#comentarios_edit').val(o[0].comentarios);

        // let comentarios_edit = document.getElementById('comentarios_edit');
        // comentarios_edit.innerHTML = o[0].comentarios;
    });
}