<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Formulario de reporte</title>
    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

    <div class="container mt-5">
        <div class="card shadow">
            <div class="card-header bg-primary text-white">
                <h4 class="mb-0">Resultado del cargue el archivo..</h4>
            </div>
            <div class="card-body">
                <?php  
                include('database.php');
                require 'vendor/autoload.php';  // Cargar PhpSpreadsheet  
                use PhpOffice\PhpSpreadsheet\IOFactory;
                
                if (isset($_FILES['archivo'])) {
                    $archivo = $_FILES['archivo'];
                    $nombre = basename($archivo['name']);
                    $tipo_mime = $archivo['type'];
                    $extension = pathinfo($nombre, PATHINFO_EXTENSION);
                
                    // Extensiones y tipos MIME permitidos
                    $extensiones_permitidas = ['xls', 'xlsx'];
                    $tipos_mime_permitidos = [
                        'application/vnd.ms-excel',                     // .xls
                        'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' // .xlsx
                    ];
                
                    // Verifica errores
                    if ($archivo['error'] === UPLOAD_ERR_OK) {
                
                        // Validar extensión y tipo MIME
                        if (in_array(strtolower($extension), $extensiones_permitidas) &&
                            in_array($tipo_mime, $tipos_mime_permitidos)) {
                
                            $ruta_destino = $nombre;
                
                            if (move_uploaded_file($archivo['tmp_name'], $ruta_destino)) {
                                 
                                // Leer archivo Excel   INFO_COMERCIAL_SPH
                                $archivoExcel = $ruta_destino; // Ruta del archivo
                                $spreadsheet = IOFactory::load($archivoExcel);
                                $worksheet = $spreadsheet->getActiveSheet();
                                $truncate = mysqli_query($mysqli,"TRUNCATE TABLE info_listado_facturas") or die('Error en la truncate'. mysqli_error($mysqli));
                                // Iterar sobre filas y guardar en MySQL
                                foreach ($worksheet->getRowIterator(2) as $row) { // Empezar desde la fila 2 (omitir encabezado)
                                    $cellIterator = $row->getCellIterator();
                                    $cellIterator->setIterateOnlyExistingCells(false);
                                
                                    $data = [];
                                    foreach ($cellIterator as $cell) {
                                        $data[] = $cell->getFormattedValue();
                                    }
                                    $v = str_replace(",", "", $data[16]);
                                    $insert = mysqli_query($mysqli,"INSERT INTO info_listado_facturas VALUES(NULL,'$data[0]','$data[1]','$data[2]','$data[3]','$data[4]','$data[5]','$data[6]','$data[7]','$data[8]','$data[9]','$data[10]','$data[11]','$data[12]','$data[13]','$data[14]','$data[15]','$v','$data[17]','$data[18]')") or die('Error en la consulta'. mysqli_error($mysqli));
                                }
                                
                                
                                $query = mysqli_query($mysqli, "SELECT * FROM `info_listado_facturas` WHERE codigo_cliente IN(SELECT DISTINCT cliente FROM `info_clientes_lineas` WHERE 1) AND reser01=''") or die('Error en la consulta'. mysqli_error($mysqli));
                                while ($row = mysqli_fetch_array($query)) {
                                	$id = $row['id_factura'];
                                	$cod_tipo_cli = $row['codigo_tipo_cliente'];
                                	$tipo_cli = $row['tipo_cliente'];
                                	$cliente = $row['codigo_cliente'];
                                	$nom_cliente = $row['cliente'];
                                	$factura = $row['factura'];
                                	$fecha_fact = $row['fecha_factura'];
                                	$cod_articulo = $row['codigo_articulo'];
                                	$articulo = $row['articulo'];	
                                	$linea = $row['linea_comercial'];
                                	$dr1 = $row['reser01'];
                                	$dr2 = $row['reser02'];
                                	$valor = str_replace(',', '', $row['importe_neto']);
                                	$cantidad = str_replace(',', '', $row['unidades_servidas']);
                                	$query1 = mysqli_query($mysqli, "SELECT * FROM `info_clientes_lineas` WHERE cliente='$cliente' AND linea='$linea'") or die('Error en la consulta'. mysqli_error($mysqli));
                                	while ($row1 = mysqli_fetch_array($query1)) {
                                		$cod_zona_n = $row1['cod_zona'];
                                		$zona_n = $row1['zona'];
                                		$cod_vendedor_n = $row1['cod_vendedor'];
                                		$vendedor_n = $row1['vendedor'];
                                		$valor_n = number_format($valor*($row1['valor']/100), 2, '.', ',');
                                		$cantidad_n = number_format($cantidad*($row1['valor']/100), 2, '.', ',');
                                        
                                		$insert = mysqli_query($mysqli,"INSERT INTO info_listado_facturas VALUES(NULL,'$cod_zona_n','$zona_n','$cod_vendedor_n','$vendedor_n','$cod_tipo_cli','$tipo_cli','$cliente','$nom_cliente','Factura:','$factura','F.Factura','$fecha_fact','$cod_articulo','$articulo','$cantidad_n','$valor_n','$linea','$dr1','$dr2')") or die('Error en la inserci贸n'. mysqli_error($mysqli));
                                	}
                                	$delete = mysqli_query($mysqli, "DELETE FROM `info_listado_facturas` WHERE id_factura='$id'") or die('Error en borrado'. mysqli_error($mysqli));
                                
                                }
                                echo '
                                <div class="alert alert-success d-flex justify-content-between align-items-center" role="alert">
                                    <span>
                                        <span class="badge bg-success me-2">✅</span> 
                                        Archivo Excel subido correctamente: <strong>' . htmlspecialchars($nombre) . '</strong>
                                    </span>
                                    <a href="https://visitapp.logitrack.com.co/reporte_ventas/reporte.php" class="btn btn-primary btn-sm" download>Descargar Reporte</a>
                                </div>';
                            } else {
                                echo "❌ Error al mover el archivo.";
                            }
                
                        } else {
                            echo "❌ Solo se permiten archivos Excel (.xls o .xlsx).";
                        }
                
                    } else {
                        echo "❌ Error al subir el archivo. Código: " . $archivo['error'];
                    }
                
                } else {
                    echo "❌ No se recibió ningún archivo.";
                }
            
                exit();
                ?>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS (opcional, solo si usas componentes interactivos) -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>