<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);
include('database.php');
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;



// Consulta SQL
$query = mysqli_query($mysqli, "SELECT * FROM info_listado_facturas WHERE 1 order by factura, codigo_articulo") or die('Error en la consulta'. mysqli_error($mysqli));

// Crear un nuevo Excel
$spreadsheet = new Spreadsheet();
$hoja = $spreadsheet->getActiveSheet();

// Encabezados
$hoja->setCellValue('A1', 'COD ZONA CLIENTE');
$hoja->setCellValue('B1', 'ZONA CLIENTE');
$hoja->setCellValue('C1', 'COD VENDEDOR');
$hoja->setCellValue('D1', 'VENDEDOR');
$hoja->setCellValue('E1', 'LINEA');
$hoja->setCellValue('F1', 'CLIENTE');
$hoja->setCellValue('G1', 'D CLIENTE');
$hoja->setCellValue('H1', 'COD FACTURA');
$hoja->setCellValue('I1', 'FACTURA');
$hoja->setCellValue('J1', 'COD F.FACTURA');
$hoja->setCellValue('K1', 'F.FACTURA');
$hoja->setCellValue('L1', 'ARTICULO');
$hoja->setCellValue('M1', 'D ARTICULO');
$hoja->setCellValue('N1', 'UNIDADES SERVIDAS');
$hoja->setCellValue('O1', 'IMPORTE NETO LIN');
$hoja->setCellValue('P1', 'DIVISION');
$hoja->setCellValue('Q1', 'MOTIVO DEV');
$hoja->setCellValue('R1', 'DESC MOTIVO');

// Agregar datos
$fila = 2;
while ($filaDatos = mysqli_fetch_array($query)) {
    if($filaDatos['codigo_tipo_cliente']=='C04'){ $tipoc = "INSTITUCIONAL";}else{$tipoc = "COMERCIAL";}
    if($filaDatos['linea_comercial']=='DERMA'){$lnea = "DERMATOLOGIA";}elseif($filaDatos['linea_comercial']=='BLEMIL'){$lnea = "FORMULAS INFANTILES";}else{$lnea = $filaDatos['linea_comercial'];}
    $hoja->setCellValue('A' . $fila, $filaDatos['codigo_zona']);
    $hoja->setCellValue('B' . $fila, $filaDatos['zona_cliente']);
    $hoja->setCellValue('C' . $fila, $filaDatos['codigo_vendedor']);
    $hoja->setCellValue('D' . $fila, $filaDatos['vendedor']);
    $hoja->setCellValue('E' . $fila, $tipoc);
    $hoja->setCellValue('F' . $fila, $filaDatos['codigo_cliente']);
    $hoja->setCellValue('G' . $fila, $filaDatos['cliente']);
    $hoja->setCellValue('H' . $fila, $filaDatos['codigo_factura']);
    $hoja->setCellValue('I' . $fila, $filaDatos['factura']);
    $hoja->setCellValue('J' . $fila, $filaDatos['codigo_ffactura']);
    try {
        $fechaString = $filaDatos['fecha_factura']; // ejemplo: '10/6/2025'
        $fechaDT = \DateTime::createFromFormat('d/m/Y', $fechaString);
    
        if ($fechaDT !== false) {
            $fechaExcel = \PhpOffice\PhpSpreadsheet\Shared\Date::PHPToExcel($fechaDT);
    
            $hoja->setCellValue('K' . $fila, $fechaExcel);
    
            // Aplicar formato de fecha real en Excel
            $hoja->getStyle('K' . $fila)
                 ->getNumberFormat()
                 ->setFormatCode(NumberFormat::FORMAT_DATE_DDMMYYYY);
        } else {
            // Si no se pudo parsear, dejar como texto o escribir "Fecha inválida"
            $hoja->setCellValue('K' . $fila, 'Fecha inválida');
        }
    } catch (\Exception $e) {
        $hoja->setCellValue('K' . $fila, 'Error de fecha');
}
    $hoja->setCellValue('L' . $fila, $filaDatos['codigo_articulo']);
    $hoja->setCellValue('M' . $fila, $filaDatos['articulo']);
    $hoja->setCellValue('N' . $fila, $filaDatos['unidades_servidas']);
    $hoja->setCellValue('O' . $fila, str_replace(',', '',$filaDatos['importe_neto']));
    $hoja->setCellValue('P' . $fila, $lnea);
    $hoja->setCellValue('Q' . $fila, $filaDatos['reser01']);
    $hoja->setCellValue('R' . $fila, $filaDatos['reser02']);
    $hoja->getStyle('N' . $fila)
     ->getNumberFormat()
     ->setFormatCode('#,##0.00');
    $fila++;
}

// Nombre del archivo
$nombreArchivo = 'reporte_ventas' . date('Ymd') . '.xlsx';

// Enviar encabezados para descarga
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header("Content-Disposition: attachment;filename=\"$nombreArchivo\"");
header('Cache-Control: max-age=0');

// Crear y enviar el archivo
$writer = new Xlsx($spreadsheet);
$writer->save('php://output');
exit;
